﻿uses
  Classes, Common, DataEntry, DataStorage, DateUtils, SysUtils, Variants;

// OnStart filter --------------------------------------------------------------
procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj: TObject);
const
  SPACE = ' ';

var
  TwoDates_StringList: TStringList;
  btw_endng_var: variant;
  btw_start_var: variant;
  tmp_dt: TDateTime;
  FilterFileName_log_str: string;
  FilterPath_str: string;
  LogFileFullPath_str: string;
  FilterFileName_pas_str: string;
  FilterFileName_txt_str: string;
  FilterLogging_StringList: TStringList;

begin
  DoContinue := True;
  FilterPath_str := CmdLine.Path;
  FilterFileName_pas_str := ExtractFileName(FilterPath_str);
  FilterLogging_StringList := TStringList.Create;
  try
    if CmdLine.ParamCount > 0 then
    begin
      TwoDates_StringList := TStringList.Create;
      if CmdLine.ParamCount = 2 then
      begin
        btw_start_var := CmdLine.params[0];
        btw_endng_var := CmdLine.params[1];

        try
          tmp_dt := VarToDateTime(btw_start_var);
          TwoDates_StringList.Add(btw_start_var);
        except
          FilterLogging_StringList.Add('Error converting btw_start_var');
          Exit;
        end;

        try
          tmp_dt := VarToDateTime(btw_endng_var);
          TwoDates_StringList.Add(btw_endng_var);
        except
          FilterLogging_StringList.Add('Error converting btw_endng_var');
          Exit;
        end;
      end
      else
        FilterLogging_StringList.Add('Did not receive 2 parameters');
    end
    else
      FilterLogging_StringList.Add('No parameters received.');

    // Save Manual Log File
    FilterFileName_log_str := StringReplace(FilterFileName_pas_str, '.pas', '.log', [rfReplaceAll, rfIgnoreCase]);
    LogFileFullPath_str := GetCurrentCaseDir + 'Logs' + '\' + 'FILTER - ' + SPACE + UpperCase(FilterFileName_log_str);
    FilterLogging_StringList.Add('Log File: ' + LogFileFullPath_str);
    FilterLogging_StringList.SaveToFile(LogFileFullPath_str);

  finally
    FilterLogging_StringList.free;
  end;
  OutObj := TwoDates_StringList;
end;

// Run the filter --------------------------------------------------------------
function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  start_dt: TDateTime;
  end_dt: TDateTime;
  aStringList: TStringList;
  endng_var: variant;
  start_var: variant;

begin
  Result := -1; // Exclude

  if (InObj = nil) or not(InObj is TStringList) then
    Exit;

  aStringList := TStringList(InObj);

  if aStringList.Count <> 2 then
    Exit;

  start_var := aStringList[0];
  endng_var := aStringList[1];

  start_dt := VarToDateTime(start_var);
  end_dt := VarToDateTime(endng_var);

  if assigned(anEntry) then
  begin
    if (CompareDate(anEntry.Created, start_dt) = -1) or (CompareDate(anEntry.Created, end_dt) = 1) then
    begin
      Result := -1; // Exclude
    end
    else
      Result := 1; // Include
  end;
end;

procedure OnendFilter(Var OutObj: TObject);
begin
  if (OutObj <> nil) and (OutObj is TStringList) then
    OutObj.free;
end;

begin

end.
